import{Color,FrontSide,Matrix4,Mesh,PerspectiveCamera,Plane,ShaderMaterial,UniformsLib,UniformsUtils,Vector3,Vector4,WebGLRenderTarget}from"three";class Water extends Mesh{constructor(t,e={}){super(t),this.isWater=1;const r=this,o=void 0!==e.textureWidth?e.textureWidth:512,n=void 0!==e.textureHeight?e.textureHeight:512,i=void 0!==e.clipBias?e.clipBias:0,a=void 0!==e.alpha?e.alpha:1,l=void 0!==e.time?e.time:0,s=void 0!==e.waterNormals?e.waterNormals:null,c=void 0!==e.sunDirection?e.sunDirection:new Vector3(.70707,.70707,0),m=new Color(void 0!==e.sunColor?e.sunColor:16777215),u=new Color(void 0!==e.waterColor?e.waterColor:8355711),d=void 0!==e.eye?e.eye:new Vector3(0,0,0),v=void 0!==e.distortionScale?e.distortionScale:20,f=void 0!==e.side?e.side:FrontSide,p=void 0!==e.fog?e.fog:0,x=new Plane,g=new Vector3,h=new Vector3,w=new Vector3,y=new Matrix4,C=new Vector3(0,0,-1),M=new Vector4,S=new Vector3,_=new Vector3,b=new Vector4,D=new Matrix4,V=new PerspectiveCamera,P=new WebGLRenderTarget(o,n),L={name:"MirrorShader",uniforms:UniformsUtils.merge([UniformsLib.fog,UniformsLib.lights,{normalSampler:{value:null},mirrorSampler:{value:null},alpha:{value:1},time:{value:0},size:{value:1},distortionScale:{value:20},textureMatrix:{value:new Matrix4},sunColor:{value:new Color(8355711)},sunDirection:{value:new Vector3(.70707,.70707,0)},eye:{value:new Vector3},waterColor:{value:new Color(5592405)}}]),vertexShader:"\n\t\t\t\tuniform mat4 textureMatrix;\n\t\t\t\tuniform float time;\n\n\t\t\t\tvarying vec4 mirrorCoord;\n\t\t\t\tvarying vec4 worldPosition;\n\n\t\t\t\t#include <common>\n\t\t\t\t#include <fog_pars_vertex>\n\t\t\t\t#include <shadowmap_pars_vertex>\n\t\t\t\t#include <logdepthbuf_pars_vertex>\n\n\t\t\t\tvoid main() {\n\t\t\t\t\tmirrorCoord = modelMatrix * vec4( position, 1.0 );\n\t\t\t\t\tworldPosition = mirrorCoord.xyzw;\n\t\t\t\t\tmirrorCoord = textureMatrix * mirrorCoord;\n\t\t\t\t\tvec4 mvPosition =  modelViewMatrix * vec4( position, 1.0 );\n\t\t\t\t\tgl_Position = projectionMatrix * mvPosition;\n\n\t\t\t\t#include <beginnormal_vertex>\n\t\t\t\t#include <defaultnormal_vertex>\n\t\t\t\t#include <logdepthbuf_vertex>\n\t\t\t\t#include <fog_vertex>\n\t\t\t\t#include <shadowmap_vertex>\n\t\t\t}",fragmentShader:"\n\t\t\t\tuniform sampler2D mirrorSampler;\n\t\t\t\tuniform float alpha;\n\t\t\t\tuniform float time;\n\t\t\t\tuniform float size;\n\t\t\t\tuniform float distortionScale;\n\t\t\t\tuniform sampler2D normalSampler;\n\t\t\t\tuniform vec3 sunColor;\n\t\t\t\tuniform vec3 sunDirection;\n\t\t\t\tuniform vec3 eye;\n\t\t\t\tuniform vec3 waterColor;\n\n\t\t\t\tvarying vec4 mirrorCoord;\n\t\t\t\tvarying vec4 worldPosition;\n\n\t\t\t\tvec4 getNoise( vec2 uv ) {\n\t\t\t\t\tvec2 uv0 = ( uv / 103.0 ) + vec2(time / 17.0, time / 29.0);\n\t\t\t\t\tvec2 uv1 = uv / 107.0-vec2( time / -19.0, time / 31.0 );\n\t\t\t\t\tvec2 uv2 = uv / vec2( 8907.0, 9803.0 ) + vec2( time / 101.0, time / 97.0 );\n\t\t\t\t\tvec2 uv3 = uv / vec2( 1091.0, 1027.0 ) - vec2( time / 109.0, time / -113.0 );\n\t\t\t\t\tvec4 noise = texture2D( normalSampler, uv0 ) +\n\t\t\t\t\t\ttexture2D( normalSampler, uv1 ) +\n\t\t\t\t\t\ttexture2D( normalSampler, uv2 ) +\n\t\t\t\t\t\ttexture2D( normalSampler, uv3 );\n\t\t\t\t\treturn noise * 0.5 - 1.0;\n\t\t\t\t}\n\n\t\t\t\tvoid sunLight( const vec3 surfaceNormal, const vec3 eyeDirection, float shiny, float spec, float diffuse, inout vec3 diffuseColor, inout vec3 specularColor ) {\n\t\t\t\t\tvec3 reflection = normalize( reflect( -sunDirection, surfaceNormal ) );\n\t\t\t\t\tfloat direction = max( 0.0, dot( eyeDirection, reflection ) );\n\t\t\t\t\tspecularColor += pow( direction, shiny ) * sunColor * spec;\n\t\t\t\t\tdiffuseColor += max( dot( sunDirection, surfaceNormal ), 0.0 ) * sunColor * diffuse;\n\t\t\t\t}\n\n\t\t\t\t#include <common>\n\t\t\t\t#include <packing>\n\t\t\t\t#include <bsdfs>\n\t\t\t\t#include <fog_pars_fragment>\n\t\t\t\t#include <logdepthbuf_pars_fragment>\n\t\t\t\t#include <lights_pars_begin>\n\t\t\t\t#include <shadowmap_pars_fragment>\n\t\t\t\t#include <shadowmask_pars_fragment>\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\t#include <logdepthbuf_fragment>\n\t\t\t\t\tvec4 noise = getNoise( worldPosition.xz * size );\n\t\t\t\t\tvec3 surfaceNormal = normalize( noise.xzy * vec3( 1.5, 1.0, 1.5 ) );\n\n\t\t\t\t\tvec3 diffuseLight = vec3(0.0);\n\t\t\t\t\tvec3 specularLight = vec3(0.0);\n\n\t\t\t\t\tvec3 worldToEye = eye-worldPosition.xyz;\n\t\t\t\t\tvec3 eyeDirection = normalize( worldToEye );\n\t\t\t\t\tsunLight( surfaceNormal, eyeDirection, 100.0, 2.0, 0.5, diffuseLight, specularLight );\n\n\t\t\t\t\tfloat distance = length(worldToEye);\n\n\t\t\t\t\tvec2 distortion = surfaceNormal.xz * ( 0.001 + 1.0 / distance ) * distortionScale;\n\t\t\t\t\tvec3 reflectionSample = vec3( texture2D( mirrorSampler, mirrorCoord.xy / mirrorCoord.w + distortion ) );\n\n\t\t\t\t\tfloat theta = max( dot( eyeDirection, surfaceNormal ), 0.0 );\n\t\t\t\t\tfloat rf0 = 0.3;\n\t\t\t\t\tfloat reflectance = rf0 + ( 1.0 - rf0 ) * pow( ( 1.0 - theta ), 5.0 );\n\t\t\t\t\tvec3 scatter = max( 0.0, dot( surfaceNormal, eyeDirection ) ) * waterColor;\n\t\t\t\t\tvec3 albedo = mix( ( sunColor * diffuseLight * 0.3 + scatter ) * getShadowMask(), ( vec3( 0.1 ) + reflectionSample * 0.9 + reflectionSample * specularLight ), reflectance);\n\t\t\t\t\tvec3 outgoingLight = albedo;\n\t\t\t\t\tgl_FragColor = vec4( outgoingLight, alpha );\n\n\t\t\t\t\t#include <tonemapping_fragment>\n\t\t\t\t\t#include <colorspace_fragment>\n\t\t\t\t\t#include <fog_fragment>\t\n\t\t\t\t}"},W=new ShaderMaterial({name:L.name,uniforms:UniformsUtils.clone(L.uniforms),vertexShader:L.vertexShader,fragmentShader:L.fragmentShader,lights:1,side:f,fog:p});W.uniforms.mirrorSampler.value=P.texture,W.uniforms.textureMatrix.value=D,W.uniforms.alpha.value=a,W.uniforms.time.value=l,W.uniforms.normalSampler.value=s,W.uniforms.sunColor.value=m,W.uniforms.waterColor.value=u,W.uniforms.sunDirection.value=c,W.uniforms.distortionScale.value=v,W.uniforms.eye.value=d,r.material=W,r.onBeforeRender=function(t,e,o){if(h.setFromMatrixPosition(r.matrixWorld),w.setFromMatrixPosition(o.matrixWorld),y.extractRotation(r.matrixWorld),g.set(0,0,1),g.applyMatrix4(y),S.subVectors(h,w),S.dot(g)>0)return;S.reflect(g).negate(),S.add(h),y.extractRotation(o.matrixWorld),C.set(0,0,-1),C.applyMatrix4(y),C.add(w),_.subVectors(h,C),_.reflect(g).negate(),_.add(h),V.position.copy(S),V.up.set(0,1,0),V.up.applyMatrix4(y),V.up.reflect(g),V.lookAt(_),V.far=o.far,V.updateMatrixWorld(),V.projectionMatrix.copy(o.projectionMatrix),D.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),D.multiply(V.projectionMatrix),D.multiply(V.matrixWorldInverse),x.setFromNormalAndCoplanarPoint(g,h),x.applyMatrix4(V.matrixWorldInverse),M.set(x.normal.x,x.normal.y,x.normal.z,x.constant);const n=V.projectionMatrix;b.x=(Math.sign(M.x)+n.elements[8])/n.elements[0],b.y=(Math.sign(M.y)+n.elements[9])/n.elements[5],b.z=-1,b.w=(1+n.elements[10])/n.elements[14],M.multiplyScalar(2/M.dot(b)),n.elements[2]=M.x,n.elements[6]=M.y,n.elements[10]=M.z+1-i,n.elements[14]=M.w,d.setFromMatrixPosition(o.matrixWorld);const a=t.getRenderTarget(),l=t.xr.enabled,s=t.shadowMap.autoUpdate;r.visible=0,t.xr.enabled=0,t.shadowMap.autoUpdate=0,t.setRenderTarget(P),t.state.buffers.depth.setMask(1),0==t.autoClear&&t.clear(),t.render(e,V),r.visible=1,t.xr.enabled=l,t.shadowMap.autoUpdate=s,t.setRenderTarget(a);const c=o.viewport;void 0!==c&&t.state.viewport(c)}}}export{Water};